<?php
if ( ! defined( 'ABSPATH' ) ) exit;

/*-----------------------------------------------------------------------------------*/
/* Theme essentials! */
/*-----------------------------------------------------------------------------------*/
//setting some required settings to avoid multiple redirects caused by plugins
if(  is_admin() ) {
	update_option( 'ultimate_vc_addons_redirect', false );
	update_option( 'revslider-notices', false );
	set_transient( '_redux_activation_redirect', false, 30 );
	remove_action( 'init', 'vc_page_welcome_redirect' );
}

/**
 * Add default options and show Options Panel after activate
 * @since  4.0.0
 */
global $pagenow;
if ( is_admin() && isset( $_GET['activated'] ) && $pagenow == 'themes.php' ) {
	// Flush rewrite rules.
	flush_rewrite_rules();
	// redirect
	$tt_update_log = get_option( 'tt_temptt_opt');
	if( ! is_array($tt_update_log) ) ranbron_tt_activate_redirect(); // only redirect if its first time activation
}

// Adding redirect
function ranbron_tt_activate_redirect() {

	header( 'Location: ' . esc_url(admin_url( 'themes.php?page=tgmpa-install-plugins' )) );

} // End ranbron_tt_activate_redirect()


// Adding versions
add_action( 'current_screen', 'ranbron_tt_update_version' );
function ranbron_tt_update_version( $current_screen ) {
	if ( 'appearance_page_tgmpa-install-plugins' == $current_screen->base ) {
		if( function_exists( 'ranbron_tt_firstInst_notice' )) add_action( 'admin_notices', 'ranbron_tt_firstInst_notice' ); // add notice.
	}
	if ( 'toplevel_page__templatation' == $current_screen->base ) {

		$ranbron_fw_theme = wp_get_theme();
		$ranbron_fw_this_theme_ver = $ranbron_fw_theme->get( 'Version' );
		$theme_update_log = get_option( 'ranbron_tt_updates_log');

        if ( ! $theme_update_log ) $theme_update_log = array();

		// First update
		if ( ! in_array('1.0', $theme_update_log) ) {
			array_unshift($theme_update_log, '1.0');
			update_option( 'ranbron_tt_updates_log', $theme_update_log);
		}

		if ( ! in_array($ranbron_fw_this_theme_ver, $theme_update_log) ) {
			array_unshift($theme_update_log, $ranbron_fw_this_theme_ver);
			update_option( 'ranbron_tt_updates_log', $theme_update_log);
		}

	}
}


if ( ! function_exists( 'ranbron_fw_version' ) ) {
	function ranbron_fw_version() {
		$data = ranbron_get_theme_version_data();
		echo "\n<!-- Theme version -->\n";
		if ( isset( $data['is_child'] ) && true == $data['is_child'] ) {
			echo '<meta name="generator" content="' . esc_attr( $data['child_theme_name'] . ' ' . $data['child_theme_version'] ) . '" />' . "\n";
		}
		echo '<meta name="generator" content="' . esc_attr( $data['theme_name'] . ' ' . $data['theme_version'] ) . '" />' . "\n";
	} // End ranbron_fw_version()
}

// Add Generator meta tags
if ( ! is_admin()  ) {
	add_action( 'wp_head', 'ranbron_fw_version', 10 );
}

/**
 * Get the version data for the currently active theme.
 */
if ( ! function_exists( 'ranbron_get_theme_version_data' ) ) {
function ranbron_get_theme_version_data () {
	$response = array(
					'theme_version' => '',
					'theme_name' => '',
					'is_child' => is_child_theme(),
					'child_theme_version' => '',
					'child_theme_name' => ''
					);

	if ( function_exists( 'wp_get_theme' ) ) {
		$theme_data = wp_get_theme();
		if ( true == $response['is_child'] ) {
			$response['theme_version'] = $theme_data->parent()->Version;
			$response['theme_name'] = $theme_data->parent()->Name;

			$response['child_theme_version'] = $theme_data->Version;
			$response['child_theme_name'] = $theme_data->Name;
		} else {
			$response['theme_version'] = $theme_data->Version;
			$response['theme_name'] = $theme_data->Name;
		}
	}

	return $response;
} // End ranbron_get_theme_version_data()
}


if( !function_exists( 'ranbron_tt_firstInst_notice' )) {
	function ranbron_tt_firstInst_notice() {

			 print '<div class="updated notice is-dismissible tt-admin1"><span class="tt-admin2"> ' .
		     esc_html__( 'Thanks for Activating Ranbron WordPress theme.', 'ranbron' ) . '</span>'
			 . '<br /> <br />' .

		     esc_html__( 'Theme requires few bundled plugins to function on its full power. Please Install and Activate plugins below.', 'ranbron' )

			 . '<br />' .

		     esc_html__( 'You can choose not to install any particular plugin if you do not need it. eg woocommerce ', 'ranbron' )

			 . '<br /> <br />' .

			 '<span class="tt-admin2"> ' .
		     esc_html__( 'After plugins are activated, Click Dashboard on left top, then go to Theme Options menu for further setup.', 'ranbron' ) . '</span>'

		     . '</div>';
	}
}


/**
 * Initialize theme required features & components.
 * This is the base setting for required CPTs, based on these settings customer sees options to disable/rename rewrite for cpts in themeoptions.
 */
if(!( function_exists('ranbron_fw_theme_components') )){

	function ranbron_fw_theme_components() {

		$theme_components = array(
			'portfolio_cpt'             => '1',
			'team_cpt'                  => '0',
			'client_cpt'                => '0',
			'testimonial_cpt'           => '1',
			'project_cpt'               => '1',
			'metaboxes'                 => '1',
			'theme_options'             => '1',
			'common_shortcodes'         => '1',
			'post_shortcodes'           => '1',
			'ttnew_hero_sc'             => '1',
			'integrate_VC'              => '1',
			'tt_widget_recentpost'      => '1',
			'tt_dashboard_panel'        => '1',
			'temptt_themename'          => 'Ranbron', /* as in Stylesheet */
			'temptt_author'             => 'blv',  /* if blv or da */
			'temptt_tf_link'            => 'ranbron-wordpress-theme/22294129', /* format : itemslug/itemID */
			'temptt_new_importer'       => '1', /* whether to use the new importer */
		);
		// Let filter modify it
		$theme_components = apply_filters( 'tt_theme_components', $theme_components );
		update_option('tt_temptt_components', $theme_components);
	}

	// only trigger on first install
	global $pagenow;
	if ( is_admin() && isset( $_GET['activated'] ) && $pagenow == 'themes.php' || is_admin() && isset( $_GET['theme'] ) && $pagenow == 'customize.php' ){
		add_action( 'init', 'ranbron_fw_theme_components', 1 );
		add_action( 'init', 'ranbron_fw_user_manage_cpt', 2 ); // Trigger first run of this fn.
	}
}

/**
 * Let user disable CPT as per his needs.
 */
if(!( function_exists('ranbron_fw_user_manage_cpt') )){

	function ranbron_fw_user_manage_cpt() {

		// Fetch from DB.
		$theme_components = get_option('tt_temptt_components');
		if( !$theme_components ) return;

		// User settings.
		$theme_user_cpts = array(
			'portfolio_cpt'             => ranbron_fw_get_option( 'portfolio_cpt', $theme_components['portfolio_cpt'] ),
			'testimonial_cpt'           => ranbron_fw_get_option( 'testimonial_cpt', $theme_components['testimonial_cpt'] ),
			'team_cpt'                  => ranbron_fw_get_option( 'team_cpt', $theme_components['team_cpt'] ),
			'client_cpt'                => ranbron_fw_get_option( 'client_cpt', $theme_components['client_cpt'] ),
			'project_cpt'               => ranbron_fw_get_option( 'project_cpt', $theme_components['project_cpt'] ),
		);

		// Overwrite theme defaults with new user settings.
		$new_theme_components = wp_parse_args( $theme_user_cpts, $theme_components );

		// Save
		update_option('tt_temptt_components_user', $new_theme_components);

	}

	// only trigger on permalink page
	global $pagenow;
	if ( is_admin() && $pagenow == 'options-permalink.php' ){
		add_action( 'init', 'ranbron_fw_user_manage_cpt', 2 );
	}
}

// admin styles.
if ( ! function_exists( 'ranbron_tt_admin_styles' ) ) {
	function ranbron_tt_admin_styles() {

		wp_enqueue_style( 'ranbron-admin-css', get_template_directory_uri() . '/assets/css/tt-admin.css' );

	} add_action('admin_enqueue_scripts', 'ranbron_tt_admin_styles', 200);
}
