<?php
if ( ! defined( 'ABSPATH' ) ) exit;

/*-----------------------------------------------------------------------------------*/
/* This file hooks the metaboxes to Metabox system powered by TT FW plugin.
/*-----------------------------------------------------------------------------------*/

// remove metaoptions for CPT from the plugin.
remove_filter( 'cs_metabox_options', 'tt_temptt_team_metas_opt', 20 ); // remove the plugin team opts, if exists.
remove_filter( 'cs_metabox_options', 'tt_temptt_portfolio_metas_opt', 20 ); // remove the plugin team opts, if exists.

/*-----------------------------------------------------------------------------------*/
/* CS meta boxes override                                                            */
/*-----------------------------------------------------------------------------------*/
// framework options filter example
if( !function_exists( 'ranbron_fw_metas_opt' )) {
	function ranbron_fw_metas_opt( $options ) {



// Lets create options that we will use mostly, in page, product, pages
	$ranbron_fw_default_meta =  array(

				// begin: a section
				array(
					'name'   => 'section_1',
					'title'  => 'General Settings',
					'icon'   => 'fa fa-cog',
					// begin: fields
					'fields' => array(
						array(
						  'id'    => '_hide_title_display',
						  'type'  => 'switcher',
						  'title' => esc_html__( 'Hide default title display in middle content area.', 'ranbron' ),
						  'label'  => esc_html__( 'In some case, you might want to hide the default title display. Check this to hide title. If you are not sure about it  leave it unchecked. N/A if you have Hero section enabled on this page.', 'ranbron' ),
						  'default' => false
						),
						array(
						  'id'    => '_single_no_bpad',
						  'type'  => 'switcher',
						  'title' => esc_html__( 'Disable bottom padding.', 'ranbron' ),
						  'label'  => esc_html__( 'By default there is padding on bottom before the footer area starts. Disable it here if you want to. Note: The top padding applies only when you disable Hero area, so that option is in Hero Area section, seen when you disable Hero Image.', 'ranbron' ),
						  'default' => false,
						),

					), // end: fields
				), // end: a section

				// begin: a section
				array(
					'name'   => 'section_2',
					'title'  => 'Header Settings',
					'icon'   => 'fa fa-cog',
					// begin: fields
					'fields' => array(

						array(
						  'id'       => '_single_hdr_type',
						  'type'     => 'select',
						  'title' => esc_html__( 'Select header type.', 'ranbron' ),
						  'desc' => esc_html__( 'This overrides the global setting done on Themeoptions for this page. For demo of these header types, please check themeoptions/layout.', 'ranbron' ),
						  'options'  => array(
						    'nochange'      => esc_html__( 'As set in Themeoptions', 'ranbron' ),
						    'default'       => esc_html__( 'Default header', 'ranbron' ),
						    'header2'        => esc_html__( 'Header 2', 'ranbron' ),
						    'header3'         => esc_html__( 'Header 3', 'ranbron' ),
						    'header4'         => esc_html__( 'Header 4', 'ranbron' ),
						    'header5'         => esc_html__( 'Header 5', 'ranbron' ),
						  ),
						  'default'  => 'nochange',
						),


					), // end: fields
				), // end: a section

				array(
					'name'   => 'section_3',
					'title'  => 'Hero Section',
					'icon'   => 'fa fa-cog',
					// begin: fields
					'fields' => array(

						array(
							'id'      => '_single_enable_headline',
							'type'    => 'switcher',
							'title'   => esc_html__( 'Enable Hero section on this page', 'ranbron' ),
							'label'   => esc_html__( 'Hero section appears after header and before content area. Note: Hero section is full liquid width. If you want boxed Hero section, use page composer to build it please. Note: Page builder plugin must be active for Hero section to work.', 'ranbron' ),
							'default' => true
						),
						array(
							'id'         => '_single_headline_title',
							'type'       => 'text',
							'title'      => esc_html__( 'Main Title.', 'ranbron' ),
							'desc'      => esc_html__( 'Appears as highlight text in Hero section. If left blank, displays page title as default.', 'ranbron' ),
							'dependency' => array( '_single_enable_headline', '==', 'true' ),
						),
						array(
							'id'         => '_single_headline_desc',
							'type'       => 'textarea',
							'title'      => esc_html__( 'Description(Optional).', 'ranbron' ),
							'desc'      => esc_html__( 'Appears below highlight text in Hero section.', 'ranbron' ),
							'dependency' => array( '_single_enable_headline', '==', 'true' ),
						),
						array(
							'id'    => '_single_page_img',
							'type'  => 'upload',
							'title' => esc_html__( 'Hero area background', 'ranbron' ),
							'desc'  => esc_html__( 'This image appears in background of hero section above. Recommended image size is 1300x400 px.', 'ranbron' ),
							'dependency' => array( '_single_enable_headline', '==', 'true' ),
						),
						array(
						  'id'    => '_single_hero_breadcrumbs',
						  'type'  => 'switcher',
						  'title' => esc_html__( 'Insert breadcrumbs in Hero section.', 'ranbron' ),
						  'label'  => esc_html__( 'Insert breadcrumb in this area. Note: Yoast SEO plugin must be active, and Breadcrumb enabled in SEO/Advanced in wp-admin.', 'ranbron' ),
						  'default' => true,
						  'dependency' => array( '_single_enable_headline', '==', 'true' ),
						),

						array(
						  'id'    => '_single_no_tpad',
						  'type'  => 'switcher',
						  'title' => esc_html__( 'Disable top padding.', 'ranbron' ),
						  'label'  => esc_html__( 'As you disabled Hero section, may be you want to start content from the very top. In this case, you can disable the default top padding on top of content.', 'ranbron' ),
						  'default' => false,
						  'dependency' => array( '_single_enable_headline', '==', 'false' ),
						),

					), // end: fields
				) // end: a section
);

// Lets create options that we will use mostly, in page, product, pages
	$ranbron_fw_portfolio_meta =  array(

				// begin: a section
				array(
					'name'   => 'section_1',
					'title'  => 'General Settings',
					'icon'   => 'fa fa-cog',
					// begin: fields
					'fields' => array(
						array(
							'id'         => '_sc_icon',
							'type'       => 'text',
							'title'      => esc_html__( 'Icon.', 'ranbron' ),
							'desc'      => esc_html__( 'Enter code for icon, this icon will be used for this service in Service Carousel page builder module. eg: fa fa-bar-chart. Find all icons here https://fontawesome.com/icons. Please remember to include fa also. For example, enter "fa fa-home" without quotes.', 'ranbron' ),
						),
						array(
						  'id'    => '_hide_title_display',
						  'type'  => 'switcher',
						  'title' => esc_html__( 'Hide default title display in middle content area.', 'ranbron' ),
						  'label'  => esc_html__( 'In some case, you might want to hide the default title display. Check this to hide title. If you are not sure about it  leave it unchecked. N/A for woocommerce products.', 'ranbron' ),
						  'default' => false
						),
						array(
						  'id'    => '_single_no_bpad',
						  'type'  => 'switcher',
						  'title' => esc_html__( 'Disable bottom padding.', 'ranbron' ),
						  'label'  => esc_html__( 'By default there is padding on bottom before the footer area starts. Disable it here if you want to. Note: The top padding applies only when you disable Hero area, so that option is in Hero Area section, seen when you disable Hero Image.', 'ranbron' ),
						  'default' => false,
						),

					), // end: fields
				), // end: a section

				// begin: a section
				array(
					'name'   => 'section_2',
					'title'  => 'Header Settings',
					'icon'   => 'fa fa-cog',
					// begin: fields
					'fields' => array(

						array(
						  'id'       => '_single_hdr_type',
						  'type'     => 'select',
						  'title' => esc_html__( 'Select header type.', 'ranbron' ),
						  'desc' => esc_html__( 'This overrides the global setting done on Themeoptions for this page. For demo of these header types, please check themeoptions/layout.', 'ranbron' ),
						  'options'  => array(
						    'nochange'      => esc_html__( 'As set in Themeoptions', 'ranbron' ),
						    'default'       => esc_html__( 'Default header', 'ranbron' ),
						    'header2'        => esc_html__( 'Header 2', 'ranbron' ),
						    'header3'         => esc_html__( 'Header 3', 'ranbron' ),
						    'header4'         => esc_html__( 'Header 4', 'ranbron' ),
						    'header5'         => esc_html__( 'Header 5', 'ranbron' ),
						  ),
						  'default'  => 'nochange',
						),


					), // end: fields
				), // end: a section

				array(
					'name'   => 'section_3',
					'title'  => 'Hero Section',
					'icon'   => 'fa fa-cog',
					// begin: fields
					'fields' => array(

						array(
							'id'      => '_single_enable_headline',
							'type'    => 'switcher',
							'title'   => esc_html__( 'Enable Hero section on this page', 'ranbron' ),
							'label'   => esc_html__( 'Hero section appears after header and before content area. Note: Hero section is full liquid width. If you want boxed Hero section, use page composer to build it please. Note: Page builder plugin must be active for Hero section to work.', 'ranbron' ),
							'default' => true
						),
						array(
							'id'         => '_single_headline_title',
							'type'       => 'text',
							'title'      => esc_html__( 'Main Title.', 'ranbron' ),
							'desc'      => esc_html__( 'Appears as highlight text in Hero section. If left blank, displays page title as default.', 'ranbron' ),
							'dependency' => array( '_single_enable_headline', '==', 'true' ),
						),
						array(
							'id'         => '_single_headline_desc',
							'type'       => 'textarea',
							'title'      => esc_html__( 'Description(Optional).', 'ranbron' ),
							'desc'      => esc_html__( 'Appears below highlight text in Hero section.', 'ranbron' ),
							'dependency' => array( '_single_enable_headline', '==', 'true' ),
						),
						array(
							'id'    => '_single_page_img',
							'type'  => 'upload',
							'title' => esc_html__( 'Hero area background', 'ranbron' ),
							'desc'  => esc_html__( 'This image appears in background of hero section above. Recommended image size is 1300x400 px.', 'ranbron' ),
							'dependency' => array( '_single_enable_headline', '==', 'true' ),
						),
						array(
						  'id'      => '_single_page_color',
						  'type'    => 'color_picker',
						  'title'   => esc_html__( 'Background color.', 'ranbron' ),
						  'desc'    => esc_html__( 'You can choose to have background color, also, if you make this color transparent, it will work as overlay color on the image chosen above.', 'ranbron' ),
						  'default' => '',
						  'rgba'    => true,
						  'dependency' => array( '_single_enable_headline', '==', 'true' ),
						),

						array(
						  'id'    => '_single_hero_breadcrumbs',
						  'type'  => 'switcher',
						  'title' => esc_html__( 'Insert breadcrumbs in Hero section.', 'ranbron' ),
						  'label'  => esc_html__( 'Insert breadcrumb in this area. Note: Yoast SEO plugin must be active, and Breadcrumb enabled in SEO/Advanced in wp-admin.', 'ranbron' ),
						  'default' => true,
						  'dependency' => array( '_single_enable_headline', '==', 'true' ),
						),

						array(
						  'id'    => '_single_no_tpad',
						  'type'  => 'switcher',
						  'title' => esc_html__( 'Disable top padding.', 'ranbron' ),
						  'label'  => esc_html__( 'As you disabled Hero section, may be you want to start content from the very top. In this case, you can disable the default top padding on top of content.', 'ranbron' ),
						  'default' => false,
						  'dependency' => array( '_single_enable_headline', '==', 'false' ),
						),

					), // end: fields
				) // end: a section
);

// Lets create portfolio options that we will use mostly
	$ranbron_fw_team_meta =  array(

				// begin: a section
				array(
					'name'   => 'section_1',
					'title'  => 'Event Settings',
					'icon'   => 'fa fa-cog',
					// begin: fields
					'fields' => array(

						array(
							'id'      => '_ht_event_time',
							'type'    => 'textarea',
							'title'   => esc_html__( 'Date/Time for the Event.', 'ranbron' ),
							'desc'   => esc_html__( 'eg: 19 August 2017, (Saturday) 8:00 am - 10:00 am.', 'ranbron' ),
							'default'   => '9 August 2017
(Saturday) 8:00 am - 10:00 am.',
						),
						array(
							'id'         => '_ht_event_time_label',
							'type'       => 'text',
							'title'      => esc_html__( 'Label for Time of event.', 'ranbron' ),
							'desc'      => esc_html__( 'Just in case you want to change it. ', 'ranbron' ),
							'default'   => 'Time',
						),

						array(
							'id'      => '_ht_event_loc',
							'type'    => 'textarea',
							'title'   => esc_html__( 'Location for the Event.', 'ranbron' ),
							'default'   => '56, Marborne, Ranbron Resort
NY 18565',
						),
						array(
							'id'         => '_ht_event_loc_label',
							'type'       => 'text',
							'title'      => esc_html__( 'Label for Location of event.', 'ranbron' ),
							'desc'      => esc_html__( 'Just in case you want to change it. ', 'ranbron' ),
							'default'   => 'Location',
						),

						array(
							'id'      => '_ht_event_schedule',
							'type'    => 'textarea',
							'title'   => esc_html__( 'Schedule for the Event.', 'ranbron' ),
							'desc'   => esc_html__( 'Use # for line break.', 'ranbron' ),
							'default'   => '9:00 am Breakfast#
11:00 am Global Meeting#
1:00 pm Introductory net#
working session',
						),
						array(
							'id'         => '_ht_event_schedule_label',
							'type'       => 'text',
							'title'      => esc_html__( 'Label for Schedule of event.', 'ranbron' ),
							'desc'      => esc_html__( 'Just in case you want to change it. ', 'ranbron' ),
							'default'   => 'Event Schedule',
						),

					), // end: fields
				), // end: a section

);

// Lets create testimonial options that we will use mostly
	$ranbron_fw_testi_meta =  array(

				// begin: a section
				array(
					'name'   => 'section_1',
					'title'  => 'Testimonial Settings',
					'icon'   => 'fa fa-cog',
					// begin: fields
					'fields' => array(
						array(
						  'type'    => 'notice',
						  'class'   => 'info',
						  'content' => 'The image for this item can be added from right side featured image block.',
						),
						array(
						  'id'      => '_single_testi_pos', // another unique id
						  'type'    => 'text',
						  'title'   => 'Position/Company',
						  'desc'    => 'Designation/Position and company of the person. eg: Ceo of Minda Inc.',
						 //'help'    => 'Write something',
						 //'default' => 'do stuff',
						),

					), // end: fields
				), // end: a section

);


/* Start creating meta options. */

$options = array(); // remove old options

// -----------------------------------------
// Page Metabox Options                    -
// -----------------------------------------

		$options[] = array(
			'id'        => '_tt_meta_page_opt',
			'title'     => 'Page Options',
			'post_type' => 'page',
			'context'   => 'normal',
			'priority'  => 'default',
			'sections'  => $ranbron_fw_default_meta

		);
		$options[] = array(
			'id'        => '_tt_meta_page_opt',
			'title'     => 'Page Options',
			'post_type' => 'tt_portfolio',
			'context'   => 'normal',
			'priority'  => 'default',
			'sections'  => $ranbron_fw_portfolio_meta

		);
		$options[] = array(
			'id'        => '_tt_meta_page_opt',
			'title'     => 'Page Options',
			'post_type' => 'tt_project',
			'context'   => 'normal',
			'priority'  => 'default',
			'sections'  => $ranbron_fw_default_meta

		);
		$options[] = array(
			'id'        => '_tt_meta_page_opt',
			'title'     => 'General Options',
			'post_type' => 'tt_testimonial',
			'context'   => 'normal',
			'priority'  => 'default',
			'sections'  => $ranbron_fw_testi_meta

		);
		// Note : Meta options for CPTs are triggered from templatation-framework plugin as needed by this theme.

		return $options;

	}

	add_filter( 'cs_metabox_options', 'ranbron_fw_metas_opt', '21' );

}


