<?php
/*
 * Templatation.com
 *
 * Banner with label slider for VC
 *
 */

function tt_vc_title_fn_vc() {
    vc_map(
        array(
            'name'                    => esc_html__( 'Ranbron Title' , 'ranbron' ),
            'base'                    => 'tt_vc_title_shortcode',
			"icon"     => 'tt-vc-block',
            'description'             => esc_html__( 'Title in Ranbron theme style.', 'ranbron' ),
            "category" => esc_html__('Ranbron', 'ranbron'),
			"params" => array(
                array(
                    'type'        => 'textfield',
                    'heading'     => esc_html__( 'Upper Title', 'ranbron' ),
                    'param_name'  => 'up_title',
                    'admin_label' => true,
                    'value'       => '',
                ),
				array(
					"type" => "textarea_html",
					"class" => "",
					"heading" => esc_html__("Main title",'ranbron'),
					"param_name" => "content",
					"description" => esc_html__("Basic html allowed.",'ranbron'),
                    'admin_label' => true,
					"value" => "",
			    ),
				array(
					'type'			=> 'dropdown',
					'heading'		=> esc_html__( 'Type', 'ranbron' ),
					'param_name'	=> 'type',
					'description'	=> esc_html__( 'There are few type of titles in this theme, choose here.', 'ranbron' ),
					'value' 		=> array(
						esc_html__(' Default (recommended)', 'ranbron')	 => 'default',
						esc_html__(' Light', 'ranbron')		             => 'light',
					)
				),
			),
        )
    );
}
add_action( 'vc_before_init', 'tt_vc_title_fn_vc' );
// A must for container functionality, replace Wbc_Item with your base name from mapping for parent container
if(class_exists('WPBakeryShortCode')){
    class WPBakeryShortCode_tt_vc_title_shortcode extends WPBakeryShortCode {

    }
}
